@extends('layouts.app')

@section('main')
<div class="container-fluid">
    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-header">
                    <h3 class="card-title">Subscription Details</h3>
                    <a href="{{ route('subscriptions.index') }}" class="btn btn-secondary float-right">Back</a>
                </div>
                <div class="card-body">
                    <table class="table table-bordered">
                        <tr>
                            <th>ID</th>
                            <td>{{ $subscription->id }}</td>
                        </tr>
                        <tr>
                            <th>Tenant</th>
                            <td>{{ $subscription->tenant->name ?? 'N/A' }}</td>
                        </tr>
                        <tr>
                            <th>Plan</th>
                            <td>{{ $subscription->plan->name ?? 'N/A' }}</td>
                        </tr>
                        <tr>
                            <th>Status</th>
                            <td>{{ $subscription->status }}</td>
                        </tr>
                        <tr>
                            <th>Start Date</th>
                            <td>{{ $subscription->start_date }}</td>
                        </tr>
                        <tr>
                            <th>End Date</th>
                            <td>{{ $subscription->end_date }}</td>
                        </tr>
                        <tr>
                            <th>Price</th>
                            <td>${{ $subscription->price }}</td>
                        </tr>
                        <tr>
                            <th>Created At</th>
                            <td>{{ $subscription->created_at }}</td>
                        </tr>
                        <tr>
                            <th>Updated At</th>
                            <td>{{ $subscription->updated_at }}</td>
                        </tr>
                    </table>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection
